#ifndef IDENTITY_MATCH_EXPERIMENTER_PLUGIN_H
#define IDENTITY_MATCH_EXPERIMENTER_PLUGIN_H

#include "ExperimenterPlugin.h"
#include "PerfQueue.h"

// Don't remove this! Needed by maze simulator as hook to construct plugin.
extern "C" _EXPORT ExperimenterPlugin *instantiate_exp();

/*******************************************************
* Created: 12/20/00, CGP
*	See .cpp file for description.
* Changed: 1/13/01, CGP
*	For new API.
*******************************************************/

class IdentityMatchExperimenterPlugin : public ExperimenterPlugin {
   	public:
   	     // Don't change this! Needed by maze simulator to check version compatibility!
		int PLUGIN_API_Version() {return EXPERIMENTER_API_VER;};
      
      	// Call constructor to set up the environment for running a new rat.
      	IdentityMatchExperimenterPlugin(PortMessage *expRatPort,
      		PortMessage *envExpPort, DatabaseMessage *dbMsg, UserEnvMessage *userEnvMsg,
      		DebugServer *bugServer);
      	~IdentityMatchExperimenterPlugin();

      	// Redeclare & override virtual functions
      	void PLUGIN_Setup();
      	void PLUGIN_RunTrial();
      	void PLUGIN_RunCurrentRat();
      	void PLUGIN_RatConsumedFood();
      	void PLUGIN_RatMoved(BMessage *msg);

	private:
		void AddPerformanceRecord(int trialPhase, int goalArm, int armNumber,
			int foundFood, int consumedFood);
		void SetupForTrial();
		int GetArm(char *mode, int trialNumber);
		int RunTrialProtocol(int arm, int trialPhase);
		bool TrainCriterionSatisified();
		bool TestCriterionSatisified();
		bool RunNextTrial();
		void DoNextFamiliarizationTrial();
		
		// Set the ratNo and trialNumber for the first rat.
		void FirstRat();
		// Change ratNo and trialNumber for the next rat; returns false if cannot do so
		// because all rats have been run.
		bool NextRat();
		
		// Data Members
		int ratNo; // number of current rat
		int trialNumber;
		char *mode; // "Familiarization" or "Train" or "Test"
		PerfQueue perfQueue;
};

#endif